/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.lattices;

import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.util.representation.StringRepresentation;
import it.unive.lisa.util.representation.StructuredRepresentation;

public enum Satisfiability implements Lattice<Satisfiability>
{
    SATISFIED{

        @Override
        public Satisfiability negate() {
            return NOT_SATISFIED;
        }

        @Override
        public Satisfiability and(Satisfiability other) {
            return other;
        }

        @Override
        public Satisfiability or(Satisfiability other) {
            return this;
        }

        @Override
        public Satisfiability lub(Satisfiability other) throws SemanticException {
            if (other == UNKNOWN || other == NOT_SATISFIED) {
                return UNKNOWN;
            }
            return this;
        }

        @Override
        public boolean lessOrEqual(Satisfiability other) throws SemanticException {
            return other == this || other == UNKNOWN;
        }

        @Override
        public Satisfiability glb(Satisfiability other) {
            if (other == BOTTOM || other == NOT_SATISFIED) {
                return BOTTOM;
            }
            return this;
        }
    }
    ,
    NOT_SATISFIED{

        @Override
        public Satisfiability negate() {
            return SATISFIED;
        }

        @Override
        public Satisfiability and(Satisfiability other) {
            return this;
        }

        @Override
        public Satisfiability or(Satisfiability other) {
            return other;
        }

        @Override
        public Satisfiability lub(Satisfiability other) throws SemanticException {
            if (other == UNKNOWN || other == SATISFIED) {
                return UNKNOWN;
            }
            return this;
        }

        @Override
        public boolean lessOrEqual(Satisfiability other) throws SemanticException {
            return other == this || other == UNKNOWN;
        }

        @Override
        public Satisfiability glb(Satisfiability other) {
            if (other == BOTTOM || other == SATISFIED) {
                return BOTTOM;
            }
            return this;
        }
    }
    ,
    UNKNOWN{

        @Override
        public Satisfiability negate() {
            return this;
        }

        @Override
        public Satisfiability and(Satisfiability other) {
            if (other == NOT_SATISFIED) {
                return other;
            }
            return this;
        }

        @Override
        public Satisfiability or(Satisfiability other) {
            if (other == SATISFIED) {
                return other;
            }
            return this;
        }

        @Override
        public Satisfiability lub(Satisfiability other) throws SemanticException {
            return this;
        }

        @Override
        public boolean lessOrEqual(Satisfiability other) throws SemanticException {
            return other == UNKNOWN;
        }

        @Override
        public Satisfiability glb(Satisfiability other) {
            return other;
        }
    }
    ,
    BOTTOM{

        @Override
        public Satisfiability negate() {
            return this;
        }

        @Override
        public Satisfiability and(Satisfiability other) {
            return this;
        }

        @Override
        public Satisfiability or(Satisfiability other) {
            return this;
        }

        @Override
        public Satisfiability lub(Satisfiability other) throws SemanticException {
            return other;
        }

        @Override
        public boolean lessOrEqual(Satisfiability other) throws SemanticException {
            return true;
        }

        @Override
        public Satisfiability glb(Satisfiability other) {
            return this;
        }
    };


    public abstract Satisfiability negate();

    public abstract Satisfiability and(Satisfiability var1);

    public abstract Satisfiability or(Satisfiability var1);

    @Override
    public abstract Satisfiability glb(Satisfiability var1);

    public static Satisfiability fromBoolean(boolean bool) {
        return bool ? SATISFIED : NOT_SATISFIED;
    }

    @Override
    public Satisfiability top() {
        return UNKNOWN;
    }

    @Override
    public Satisfiability bottom() {
        return BOTTOM;
    }

    public boolean mightBeTrue() {
        return this == SATISFIED || this == UNKNOWN;
    }

    public boolean mightBeFalse() {
        return this == NOT_SATISFIED || this == UNKNOWN;
    }

    @Override
    public StructuredRepresentation representation() {
        return new StringRepresentation(this.name());
    }
}

