/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.lattices;

import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.util.representation.MapRepresentation;
import it.unive.lisa.util.representation.StringRepresentation;
import it.unive.lisa.util.representation.StructuredObject;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class FunctionalLattice<F extends FunctionalLattice<F, K, V>, K, V extends Lattice<V>>
implements BaseLattice<F>,
Iterable<Map.Entry<K, V>> {
    public Map<K, V> function;
    public final V lattice;

    public FunctionalLattice(V lattice) {
        this(lattice, null);
    }

    public FunctionalLattice(V lattice, Map<K, V> function) {
        this.lattice = lattice;
        this.function = function != null && function.isEmpty() ? null : function;
    }

    public Map<K, V> mkNewFunction(Map<K, V> other, boolean preserveNull) {
        if (other == null) {
            return preserveNull ? null : new HashMap();
        }
        return new HashMap<K, V>(other);
    }

    public Set<K> getKeys() {
        if (this.function == null) {
            return Collections.emptySet();
        }
        return this.function.keySet();
    }

    public V getState(K key) {
        if (this.isBottom()) {
            return (V)this.lattice.bottom();
        }
        if (this.isTop()) {
            return (V)this.lattice.top();
        }
        if (this.function != null && this.function.containsKey(key)) {
            return (V)((Lattice)this.function.get(key));
        }
        return this.stateOfUnknown(key);
    }

    public V getOtDefault(K key, V def) {
        if (this.isBottom()) {
            return (V)this.lattice.bottom();
        }
        if (this.isTop()) {
            return (V)this.lattice.top();
        }
        if (this.function != null && this.function.containsKey(key)) {
            return (V)((Lattice)this.function.get(key));
        }
        return def;
    }

    public abstract V stateOfUnknown(K var1);

    public F putState(K key, V state) {
        Map<K, V> result = this.mkNewFunction(this.function, false);
        result.put(key, state);
        return this.mk(this.lattice, result);
    }

    public abstract F mk(V var1, Map<K, V> var2);

    @Override
    public F lubAux(F other) throws SemanticException {
        return this.functionalLift(other, this.lattice.bottom(), this::lubKeys, (o1, o2) -> o1 == null ? o2 : o1.lub(o2));
    }

    @Override
    public F glbAux(F other) throws SemanticException {
        return this.functionalLift(other, this.lattice.top(), this::glbKeys, (o1, o2) -> o1 == null ? o2 : o1.glb(o2));
    }

    @Override
    public F wideningAux(F other) throws SemanticException {
        return this.functionalLift(other, this.lattice.bottom(), this::lubKeys, (o1, o2) -> o1 == null ? o2 : o1.widening(o2));
    }

    @Override
    public F narrowingAux(F other) throws SemanticException {
        return this.functionalLift(other, this.lattice.top(), this::glbKeys, (o1, o2) -> o1 == null ? o2 : o1.narrowing(o2));
    }

    public F functionalLift(F other, V missing, KeyFunctionalLift<K> keyLifter, FunctionalLift<V> valueLifter) throws SemanticException {
        Map<K, V> function = this.mkNewFunction(null, false);
        Set<K> keys = keyLifter.keyLift(this.getKeys(), ((FunctionalLattice)other).getKeys());
        for (K key : keys) {
            try {
                V s1 = this.getOtDefault(key, missing);
                V s2 = ((FunctionalLattice)other).getOtDefault(key, missing);
                function.put(key, valueLifter.lift(s1, s2));
            }
            catch (SemanticException e) {
                throw new SemanticException("Exception during functional lifting of key '" + key + "'", e);
            }
        }
        return this.mk(this.lattice.lub(((FunctionalLattice)other).lattice), function);
    }

    public Set<K> lubKeys(Set<K> k1, Set<K> k2) throws SemanticException {
        HashSet<K> keys = new HashSet<K>(k1);
        keys.addAll(k2);
        return keys;
    }

    public Set<K> glbKeys(Set<K> k1, Set<K> k2) throws SemanticException {
        HashSet<K> keys = new HashSet<K>(k1);
        keys.retainAll(k2);
        return keys;
    }

    @Override
    public boolean lessOrEqualAux(F other) throws SemanticException {
        if (this.function != null) {
            for (K key : this.function.keySet()) {
                V state = this.getState(key);
                if (state == null || state.lessOrEqual(((FunctionalLattice)other).getState(key))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isTop() {
        return this.lattice.isTop() && this.function == null;
    }

    @Override
    public boolean isBottom() {
        return this.lattice.isBottom() && this.function == null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.function == null ? 0 : this.function.hashCode());
        result = 31 * result + (this.lattice == null ? 0 : this.lattice.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionalLattice other = (FunctionalLattice)obj;
        if (this.function == null ? other.function != null : !this.function.equals(other.function)) {
            return false;
        }
        return !(this.lattice == null ? other.lattice != null : !this.lattice.equals(other.lattice));
    }

    @Override
    public String toString() {
        return this.representation().toString();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        if (this.function == null) {
            return Collections.emptyIterator();
        }
        return this.function.entrySet().iterator();
    }

    public Collection<V> getValues() {
        if (this.function == null) {
            return Collections.emptySet();
        }
        return this.function.values();
    }

    public Map<K, V> getMap() {
        if (this.function == null) {
            return Map.of();
        }
        return this.function;
    }

    @Override
    public StructuredRepresentation representation() {
        if (this.isTop()) {
            return Lattice.topRepresentation();
        }
        if (this.isBottom()) {
            return Lattice.bottomRepresentation();
        }
        if (this.function == null) {
            return new StringRepresentation("empty");
        }
        return new MapRepresentation(this.function, StringRepresentation::new, StructuredObject::representation);
    }

    @FunctionalInterface
    public static interface KeyFunctionalLift<K> {
        public Set<K> keyLift(Set<K> var1, Set<K> var2) throws SemanticException;
    }

    @FunctionalInterface
    public static interface FunctionalLift<V extends Lattice<V>> {
        public V lift(V var1, V var2) throws SemanticException;
    }
}

