/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.lattices;

import it.unive.lisa.analysis.ScopeToken;
import it.unive.lisa.analysis.ScopedObject;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticExceptionWrapper;
import it.unive.lisa.analysis.lattices.SetLattice;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.util.collections.CollectionUtilities;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ExpressionSet
extends SetLattice<ExpressionSet, SymbolicExpression>
implements ScopedObject<ExpressionSet> {
    public ExpressionSet() {
        this(Collections.emptySet(), false);
    }

    public ExpressionSet(SymbolicExpression exp) {
        this(Collections.singleton(exp), false);
    }

    public ExpressionSet(Set<SymbolicExpression> set) {
        this(set, false);
    }

    private ExpressionSet(boolean isTop) {
        this(Collections.emptySet(), isTop);
    }

    private ExpressionSet(Set<SymbolicExpression> set, boolean isTop) {
        super(set, isTop);
    }

    @Override
    public ExpressionSet top() {
        return new ExpressionSet(true);
    }

    @Override
    public ExpressionSet bottom() {
        return new ExpressionSet();
    }

    @Override
    public ExpressionSet mk(Set<SymbolicExpression> set) {
        return new ExpressionSet(set);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.isTop ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExpressionSet other = (ExpressionSet)obj;
        return this.isTop == other.isTop;
    }

    @Override
    public ExpressionSet lubAux(ExpressionSet other) throws SemanticException {
        HashSet<SymbolicExpression> lub = new HashSet<SymbolicExpression>();
        this.elements.stream().filter(Predicate.not(Identifier.class::isInstance)).forEach(lub::add);
        other.elements.stream().filter(Predicate.not(Identifier.class::isInstance)).forEach(lub::add);
        HashSet idlub = new HashSet();
        CollectionUtilities.join(this.onlyIds(), other.onlyIds(), idlub, (id1, id2) -> id1.getName().equals(id2.getName()), ExpressionSet::wrapper);
        idlub.forEach(lub::add);
        return new ExpressionSet(lub);
    }

    private static Identifier wrapper(Identifier id1, Identifier id2) {
        try {
            return id1.lub(id2);
        }
        catch (SemanticException e) {
            throw new SemanticExceptionWrapper(e);
        }
    }

    private Collection<Identifier> onlyIds() {
        return this.elements.stream().filter(Identifier.class::isInstance).map(Identifier.class::cast).collect(Collectors.toSet());
    }

    @Override
    public ExpressionSet pushScope(ScopeToken token) throws SemanticException {
        HashSet<SymbolicExpression> mapped = new HashSet<SymbolicExpression>();
        for (SymbolicExpression exp : this.elements) {
            mapped.add(exp.pushScope(token));
        }
        return new ExpressionSet(mapped);
    }

    @Override
    public ExpressionSet popScope(ScopeToken token) throws SemanticException {
        HashSet<SymbolicExpression> mapped = new HashSet<SymbolicExpression>();
        for (SymbolicExpression exp : this.elements) {
            mapped.add(exp.popScope(token));
        }
        return new ExpressionSet(mapped);
    }
}

