/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.heap;

import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.lattices.Satisfiability;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.HeapLocation;
import it.unive.lisa.symbolic.value.MemoryPointer;
import java.util.HashSet;

public interface MemoryOracle {
    public ExpressionSet rewrite(SymbolicExpression var1, ProgramPoint var2, SemanticOracle var3) throws SemanticException;

    default public ExpressionSet rewrite(ExpressionSet expressions, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        HashSet<SymbolicExpression> result = new HashSet<SymbolicExpression>();
        for (SymbolicExpression expr : expressions) {
            if (!expr.mightNeedRewriting()) {
                result.add(expr);
                continue;
            }
            result.addAll(this.rewrite(expr, pp, oracle).elements());
        }
        return new ExpressionSet(result);
    }

    public Satisfiability alias(SymbolicExpression var1, SymbolicExpression var2, ProgramPoint var3, SemanticOracle var4) throws SemanticException;

    default public ExpressionSet reachableFrom(SymbolicExpression e, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        HashSet<SymbolicExpression> ws = new HashSet<SymbolicExpression>();
        ws.add(e);
        HashSet<SymbolicExpression> result = new HashSet<SymbolicExpression>();
        HashSet prev = new HashSet();
        HashSet<SymbolicExpression> locs = new HashSet<SymbolicExpression>();
        this.rewrite(e, pp, oracle).elements().stream().forEach(result::add);
        do {
            ws.addAll(locs);
            prev = new HashSet(result);
            for (SymbolicExpression id : ws) {
                ExpressionSet rewritten = this.rewrite(id, pp, oracle);
                locs = new HashSet();
                for (SymbolicExpression r : rewritten) {
                    if (r instanceof MemoryPointer) {
                        HeapLocation l = ((MemoryPointer)r).getReferencedLocation();
                        locs.add(l);
                        result.add(l);
                        continue;
                    }
                    locs.add(r);
                }
            }
        } while (!prev.equals(result));
        return new ExpressionSet(result);
    }

    public Satisfiability isReachableFrom(SymbolicExpression var1, SymbolicExpression var2, ProgramPoint var3, SemanticOracle var4) throws SemanticException;

    default public Satisfiability areMutuallyReachable(SymbolicExpression x, SymbolicExpression y, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return this.isReachableFrom(x, y, pp, oracle).and(this.isReachableFrom(y, x, pp, oracle));
    }
}

