/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.heap;

import it.unive.lisa.symbolic.value.Identifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

@FunctionalInterface
public interface HeapSemanticOperation {
    public List<HeapReplacement> getSubstitution();

    public static class HeapReplacement {
        private final Set<Identifier> sources = new HashSet<Identifier>();
        private final Set<Identifier> targets = new HashSet<Identifier>();

        public void addSource(Identifier id) {
            this.sources.add(id);
        }

        public void addTarget(Identifier id) {
            this.targets.add(id);
        }

        public Set<Identifier> getSources() {
            return this.sources;
        }

        public Set<Identifier> getTargets() {
            return this.targets;
        }

        public Collection<Identifier> getIdsToForget() {
            HashSet<Identifier> copy = new HashSet<Identifier>(this.sources);
            copy.removeAll(this.targets);
            return copy;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.sources == null ? 0 : this.sources.hashCode());
            result = 31 * result + (this.targets == null ? 0 : this.targets.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HeapReplacement other = (HeapReplacement)obj;
            if (this.sources == null ? other.sources != null : !this.sources.equals(other.sources)) {
                return false;
            }
            return !(this.targets == null ? other.targets != null : !this.targets.equals(other.targets));
        }

        public String toString() {
            return "{sources: " + StringUtils.join(this.sources, (String)", ") + "} -> {targets: " + StringUtils.join(this.targets, (String)", ") + "}";
        }
    }
}

