/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.heap;

import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.ScopeToken;
import it.unive.lisa.analysis.SemanticDomain;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.heap.HeapDomain;
import it.unive.lisa.analysis.heap.HeapSemanticOperation;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.ExpressionVisitor;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.heap.HeapExpression;
import it.unive.lisa.symbolic.value.BinaryExpression;
import it.unive.lisa.symbolic.value.Constant;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.PushAny;
import it.unive.lisa.symbolic.value.PushInv;
import it.unive.lisa.symbolic.value.Skip;
import it.unive.lisa.symbolic.value.TernaryExpression;
import it.unive.lisa.symbolic.value.UnaryExpression;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.symbolic.value.operator.TypeOperator;
import it.unive.lisa.symbolic.value.operator.binary.BinaryOperator;
import java.util.HashSet;
import java.util.List;

public interface BaseHeapDomain<H extends BaseHeapDomain<H>>
extends BaseLattice<H>,
HeapDomain<H> {
    @Override
    default public H smallStepSemantics(SymbolicExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        if (expression instanceof HeapExpression) {
            return this.semanticsOf((HeapExpression)expression, pp, oracle);
        }
        if (expression instanceof UnaryExpression) {
            UnaryExpression unary = (UnaryExpression)expression;
            return (H)this.smallStepSemantics(unary.getExpression(), pp, oracle);
        }
        if (expression instanceof BinaryExpression) {
            BinaryExpression binary = (BinaryExpression)expression;
            SemanticDomain sem = this.smallStepSemantics(binary.getLeft(), pp, oracle);
            if (sem.isBottom()) {
                return (H)sem;
            }
            return (H)sem.smallStepSemantics(binary.getRight(), pp, oracle);
        }
        if (expression instanceof TernaryExpression) {
            TernaryExpression ternary = (TernaryExpression)expression;
            SemanticDomain sem1 = this.smallStepSemantics(ternary.getLeft(), pp, oracle);
            if (sem1.isBottom()) {
                return (H)sem1;
            }
            SemanticDomain sem2 = sem1.smallStepSemantics(ternary.getMiddle(), pp, oracle);
            if (sem2.isBottom()) {
                return (H)sem2;
            }
            return (H)sem2.smallStepSemantics(ternary.getRight(), pp, oracle);
        }
        if (expression instanceof ValueExpression) {
            return (H)this.mk(this);
        }
        return (H)((BaseHeapDomain)this.top());
    }

    public H mk(H var1);

    public H mk(H var1, List<HeapSemanticOperation.HeapReplacement> var2);

    @Override
    default public H pushScope(ScopeToken scope) throws SemanticException {
        return (H)this;
    }

    @Override
    default public H popScope(ScopeToken scope) throws SemanticException {
        return (H)this;
    }

    public H semanticsOf(HeapExpression var1, ProgramPoint var2, SemanticOracle var3) throws SemanticException;

    public static abstract class Rewriter
    implements ExpressionVisitor<ExpressionSet> {
        protected SymbolicExpression removeTypingExpressions(SymbolicExpression e) {
            BinaryExpression be;
            BinaryOperator op;
            if (e instanceof BinaryExpression && (op = (be = (BinaryExpression)e).getOperator()) instanceof TypeOperator) {
                return this.removeTypingExpressions(be.getRight());
            }
            return e;
        }

        @Override
        public ExpressionSet visit(UnaryExpression expression, ExpressionSet arg, Object ... params) throws SemanticException {
            HashSet<SymbolicExpression> result = new HashSet<SymbolicExpression>();
            for (SymbolicExpression expr : arg) {
                UnaryExpression e = new UnaryExpression(expression.getStaticType(), expr, expression.getOperator(), expression.getCodeLocation());
                result.add(e);
            }
            return new ExpressionSet(result);
        }

        @Override
        public ExpressionSet visit(BinaryExpression expression, ExpressionSet left, ExpressionSet right, Object ... params) throws SemanticException {
            HashSet<SymbolicExpression> result = new HashSet<SymbolicExpression>();
            for (SymbolicExpression l : left) {
                for (SymbolicExpression r : right) {
                    BinaryExpression e = new BinaryExpression(expression.getStaticType(), l, r, expression.getOperator(), expression.getCodeLocation());
                    result.add(e);
                }
            }
            return new ExpressionSet(result);
        }

        @Override
        public ExpressionSet visit(TernaryExpression expression, ExpressionSet left, ExpressionSet middle, ExpressionSet right, Object ... params) throws SemanticException {
            HashSet<SymbolicExpression> result = new HashSet<SymbolicExpression>();
            for (SymbolicExpression l : left) {
                for (SymbolicExpression m : middle) {
                    for (SymbolicExpression r : right) {
                        TernaryExpression e = new TernaryExpression(expression.getStaticType(), l, m, r, expression.getOperator(), expression.getCodeLocation());
                        result.add(e);
                    }
                }
            }
            return new ExpressionSet(result);
        }

        @Override
        public ExpressionSet visit(Skip expression, Object ... params) throws SemanticException {
            return new ExpressionSet(expression);
        }

        @Override
        public ExpressionSet visit(PushAny expression, Object ... params) throws SemanticException {
            return new ExpressionSet(expression);
        }

        @Override
        public ExpressionSet visit(PushInv expression, Object ... params) throws SemanticException {
            return new ExpressionSet(expression);
        }

        @Override
        public ExpressionSet visit(Constant expression, Object ... params) throws SemanticException {
            return new ExpressionSet(expression);
        }

        @Override
        public ExpressionSet visit(Identifier expression, Object ... params) throws SemanticException {
            return new ExpressionSet(expression);
        }

        public ExpressionSet visit(HeapExpression expression, ExpressionSet[] subExpressions, Object ... params) throws SemanticException {
            throw new SemanticException("No rewriting rule for heap expression of type " + expression.getClass().getName());
        }

        public ExpressionSet visit(ValueExpression expression, ExpressionSet[] subExpressions, Object ... params) throws SemanticException {
            throw new SemanticException("No rewriting rule for value expression of type " + expression.getClass().getName());
        }
    }
}

