/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.dataflow;

import it.unive.lisa.analysis.ScopedObject;
import it.unive.lisa.analysis.SemanticEvaluator;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.dataflow.DataflowDomain;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.PushInv;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.type.Type;
import it.unive.lisa.util.representation.StructuredObject;
import java.util.Collection;
import java.util.Set;

public interface DataflowElement<D extends DataflowDomain<D, E>, E extends DataflowElement<D, E>>
extends SemanticEvaluator,
StructuredObject,
ScopedObject<E> {
    public Collection<Identifier> getInvolvedIdentifiers();

    public Collection<E> gen(Identifier var1, ValueExpression var2, ProgramPoint var3, D var4) throws SemanticException;

    public Collection<E> gen(ValueExpression var1, ProgramPoint var2, D var3) throws SemanticException;

    public Collection<E> kill(Identifier var1, ValueExpression var2, ProgramPoint var3, D var4) throws SemanticException;

    public Collection<E> kill(ValueExpression var1, ProgramPoint var2, D var3) throws SemanticException;

    @Override
    default public boolean canProcess(SymbolicExpression expression, ProgramPoint pp, SemanticOracle oracle) {
        if (expression instanceof PushInv) {
            return expression.getStaticType().isValueType();
        }
        Set<Type> rts = null;
        try {
            rts = oracle.getRuntimeTypesOf(expression, pp, oracle);
        }
        catch (SemanticException e) {
            return false;
        }
        if (rts == null || rts.isEmpty()) {
            return true;
        }
        return rts.stream().anyMatch(Type::isValueType);
    }
}

