/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis.dataflow;

import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.ScopeToken;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.dataflow.DataflowElement;
import it.unive.lisa.analysis.lattices.Satisfiability;
import it.unive.lisa.analysis.value.ValueDomain;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.symbolic.value.ValueExpression;
import it.unive.lisa.util.representation.SetRepresentation;
import it.unive.lisa.util.representation.StructuredObject;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;

public abstract class DataflowDomain<D extends DataflowDomain<D, E>, E extends DataflowElement<D, E>>
implements BaseLattice<D>,
ValueDomain<D> {
    private final boolean isTop;
    private final boolean isBottom;
    private final Set<E> elements;
    public final E domain;

    public DataflowDomain(E domain, Set<E> elements, boolean isTop, boolean isBottom) {
        this.elements = elements;
        this.domain = domain;
        this.isTop = isTop;
        this.isBottom = isBottom;
    }

    public abstract D mk(E var1, Set<E> var2, boolean var3, boolean var4);

    @Override
    public D assign(Identifier id, ValueExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return this.update(() -> !this.domain.canProcess(expression, pp, oracle), () -> this.domain.gen(id, expression, pp, (DataflowDomain)this), () -> this.domain.kill(id, expression, pp, (DataflowDomain)this));
    }

    @Override
    public D smallStepSemantics(ValueExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return this.update(() -> !this.domain.canProcess(expression, pp, oracle), () -> this.domain.gen(expression, pp, (DataflowDomain)this), () -> this.domain.kill(expression, pp, (DataflowDomain)this));
    }

    private D update(BooleanSupplier guard, SemanticElementsSupplier<E> gen, SemanticElementsSupplier<E> kill) throws SemanticException {
        if (this.isBottom()) {
            return (D)this;
        }
        if (guard.getAsBoolean()) {
            return (D)this;
        }
        HashSet<DataflowElement> updated = new HashSet<DataflowElement>(this.getDataflowElements());
        for (DataflowElement killed : kill.get()) {
            updated.remove(killed);
        }
        for (DataflowElement generated : gen.get()) {
            updated.add(generated);
        }
        return this.mk(this.domain, updated, false, false);
    }

    @Override
    public D assume(ValueExpression expression, ProgramPoint src, ProgramPoint dest, SemanticOracle oracle) throws SemanticException {
        return (D)this;
    }

    @Override
    public D forgetIdentifier(Identifier id) throws SemanticException {
        if (this.isTop()) {
            return (D)this;
        }
        LinkedList<DataflowElement> toRemove = new LinkedList<DataflowElement>();
        for (DataflowElement e : this.elements) {
            if (!e.getInvolvedIdentifiers().contains(id)) continue;
            toRemove.add(e);
        }
        if (toRemove.isEmpty()) {
            return (D)this;
        }
        HashSet<E> updated = new HashSet<E>(this.elements);
        updated.removeAll(toRemove);
        return this.mk(this.domain, updated, false, false);
    }

    @Override
    public D forgetIdentifiersIf(Predicate<Identifier> test) throws SemanticException {
        if (this.isTop()) {
            return (D)this;
        }
        LinkedList<DataflowElement> toRemove = new LinkedList<DataflowElement>();
        for (DataflowElement e : this.elements) {
            if (!e.getInvolvedIdentifiers().stream().anyMatch(test::test)) continue;
            toRemove.add(e);
        }
        if (toRemove.isEmpty()) {
            return (D)this;
        }
        HashSet<E> updated = new HashSet<E>(this.elements);
        updated.removeAll(toRemove);
        return this.mk(this.domain, updated, false, false);
    }

    @Override
    public Satisfiability satisfies(ValueExpression expression, ProgramPoint pp, SemanticOracle oracle) throws SemanticException {
        return Satisfiability.UNKNOWN;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = 31 * result + (this.elements == null ? 0 : this.elements.hashCode());
        result = 31 * result + (this.isBottom ? 1231 : 1237);
        result = 31 * result + (this.isTop ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataflowDomain other = (DataflowDomain)obj;
        if (this.domain == null ? other.domain != null : !this.domain.equals(other.domain)) {
            return false;
        }
        if (this.elements == null ? other.elements != null : !this.elements.equals(other.elements)) {
            return false;
        }
        if (this.isBottom != other.isBottom) {
            return false;
        }
        return this.isTop == other.isTop;
    }

    @Override
    public StructuredRepresentation representation() {
        return new SetRepresentation(this.elements, StructuredObject::representation);
    }

    @Override
    public D top() {
        return this.mk(this.domain, new HashSet(), true, false);
    }

    @Override
    public boolean isTop() {
        return this.elements.isEmpty() && this.isTop;
    }

    @Override
    public D bottom() {
        return this.mk(this.domain, new HashSet(), false, true);
    }

    @Override
    public boolean isBottom() {
        return this.elements.isEmpty() && this.isBottom;
    }

    public final Set<E> getDataflowElements() {
        return this.elements;
    }

    @Override
    public D pushScope(ScopeToken scope) throws SemanticException {
        if (this.isTop() || this.isBottom()) {
            return (D)this;
        }
        HashSet<DataflowElement> result = new HashSet<DataflowElement>();
        for (DataflowElement element : this.elements) {
            DataflowElement pushed = (DataflowElement)element.pushScope(scope);
            if (pushed == null) continue;
            result.add(pushed);
        }
        return this.mk(this.domain, result, false, false);
    }

    @Override
    public D popScope(ScopeToken scope) throws SemanticException {
        if (this.isTop() || this.isBottom()) {
            return (D)this;
        }
        HashSet<DataflowElement> result = new HashSet<DataflowElement>();
        for (DataflowElement element : this.elements) {
            DataflowElement popped = (DataflowElement)element.popScope(scope);
            if (popped == null) continue;
            result.add(popped);
        }
        return this.mk(this.domain, result, false, false);
    }

    @Override
    public final String toString() {
        return this.representation().toString();
    }

    @Override
    public boolean knowsIdentifier(Identifier id) {
        return this.elements.stream().anyMatch(e -> e.getInvolvedIdentifiers().contains(id));
    }

    private static interface SemanticElementsSupplier<E> {
        public Collection<E> get() throws SemanticException;
    }
}

