/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.lattices.FunctionalLattice;
import it.unive.lisa.program.cfg.statement.Statement;
import java.util.Map;

public class StatementStore<A extends AbstractState<A>>
extends FunctionalLattice<StatementStore<A>, Statement, AnalysisState<A>> {
    public StatementStore(AnalysisState<A> state) {
        super(state);
    }

    private StatementStore(AnalysisState<A> state, Map<Statement, AnalysisState<A>> function) {
        super(state, function);
    }

    public AnalysisState<A> put(Statement st, AnalysisState<A> state) {
        if (this.function == null) {
            this.function = this.mkNewFunction(null, false);
        }
        return this.function.put(st, state);
    }

    public void forget(Statement st) {
        if (this.function == null) {
            return;
        }
        this.function.remove(st);
        if (this.function.isEmpty()) {
            this.function = null;
        }
    }

    @Override
    public StatementStore<A> top() {
        return new StatementStore<A>(((AnalysisState)this.lattice).top());
    }

    @Override
    public StatementStore<A> bottom() {
        return new StatementStore<A>(((AnalysisState)this.lattice).bottom());
    }

    @Override
    public StatementStore<A> mk(AnalysisState<A> lattice, Map<Statement, AnalysisState<A>> function) {
        return new StatementStore<A>(lattice, function);
    }

    @Override
    public AnalysisState<A> stateOfUnknown(Statement key) {
        return ((AnalysisState)this.lattice).bottom();
    }
}

