/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis;

import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.ScopedObject;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.lattices.Satisfiability;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.util.representation.StructuredObject;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Predicate;

public interface SemanticDomain<D extends SemanticDomain<D, E, I>, E extends SymbolicExpression, I extends Identifier>
extends StructuredObject,
ScopedObject<D> {
    public D assign(I var1, E var2, ProgramPoint var3, SemanticOracle var4) throws SemanticException;

    public D smallStepSemantics(E var1, ProgramPoint var2, SemanticOracle var3) throws SemanticException;

    public D assume(E var1, ProgramPoint var2, ProgramPoint var3, SemanticOracle var4) throws SemanticException;

    public boolean knowsIdentifier(Identifier var1);

    public D forgetIdentifier(Identifier var1) throws SemanticException;

    public D forgetIdentifiersIf(Predicate<Identifier> var1) throws SemanticException;

    default public D forgetIdentifiers(Iterable<Identifier> ids) throws SemanticException {
        SemanticDomain<D, E, I> result = this;
        for (Identifier id : ids) {
            result = result.forgetIdentifier(id);
        }
        return (D)result;
    }

    public Satisfiability satisfies(E var1, ProgramPoint var2, SemanticOracle var3) throws SemanticException;

    default public <T extends SemanticDomain<T, ?, ?> & Lattice<T>> T getDomainInstance(Class<T> domain) throws SemanticException {
        Collection<T> all = this.getAllDomainInstances(domain);
        SemanticDomain result = null;
        for (SemanticDomain instance : all) {
            if (result == null) {
                result = instance;
                continue;
            }
            result = ((Lattice)((Object)result)).lub(instance);
        }
        return (T)result;
    }

    default public <T extends SemanticDomain<?, ?, ?>> Collection<T> getAllDomainInstances(Class<T> domain) {
        HashSet<SemanticDomain> result = new HashSet<SemanticDomain>();
        if (domain.isAssignableFrom(this.getClass())) {
            result.add(this);
        }
        return result;
    }
}

