/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis;

import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.util.representation.MapRepresentation;
import it.unive.lisa.util.representation.StringRepresentation;
import it.unive.lisa.util.representation.StructuredObject;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.SetUtils;

public class FixpointInfo
implements BaseLattice<FixpointInfo>,
Iterable<Map.Entry<String, Lattice<?>>> {
    public static final FixpointInfo BOTTOM = new FixpointInfo(){

        @Override
        public boolean isBottom() {
            return true;
        }

        @Override
        public boolean isTop() {
            return false;
        }
    };
    public Map<String, Lattice<?>> function;

    public FixpointInfo() {
        this(null);
    }

    public FixpointInfo(Map<String, Lattice<?>> mapping) {
        this.function = mapping != null && mapping.isEmpty() ? null : mapping;
    }

    private Map<String, Lattice<?>> mkNewFunction(Map<String, Lattice<?>> other, boolean preserveNull) {
        if (other == null) {
            return preserveNull ? null : new HashMap();
        }
        return new HashMap(other);
    }

    public Lattice<?> get(String key) {
        if (this.isBottom() || this.isTop() || this.function == null) {
            return null;
        }
        return this.function.get(key);
    }

    public <T> T get(String key, Class<T> type) {
        return (T)this.get(key);
    }

    public FixpointInfo put(String key, Lattice<?> info) {
        Map<String, Lattice<?>> result = this.mkNewFunction(this.function, false);
        result.put(key, info);
        return new FixpointInfo(result);
    }

    public FixpointInfo putWeak(String key, Lattice<?> info) throws SemanticException {
        Map<String, Lattice<?>> result = this.mkNewFunction(this.function, false);
        Lattice<?> prev = this.get(key);
        if (prev.getClass() != info.getClass()) {
            throw new IllegalArgumentException("The given lattice instance has a different type (" + info.getClass().getName() + ") from the one already associated with the given key (" + prev.getClass().getName() + ")");
        }
        result.put(key, prev != null ? prev.lub(info) : info);
        return new FixpointInfo(result);
    }

    @Override
    public FixpointInfo lubAux(FixpointInfo other) throws SemanticException {
        Map<String, Lattice<?>> function = this.mkNewFunction(null, false);
        SetUtils.SetView keys = SetUtils.union(this.getKeys(), other.getKeys());
        for (String key : keys) {
            try {
                Lattice<?> v = this.get(key);
                Lattice<?> o = other.get(key);
                if (v != null && o != null) {
                    function.put(key, v.lub(o));
                    continue;
                }
                if (v != null) {
                    function.put(key, v);
                    continue;
                }
                function.put(key, o);
            }
            catch (SemanticException e) {
                throw new SemanticException("Exception while operating on '" + key + "'", e);
            }
        }
        return new FixpointInfo(function);
    }

    @Override
    public FixpointInfo glbAux(FixpointInfo other) throws SemanticException {
        Map<String, Lattice<?>> function = this.mkNewFunction(null, false);
        SetUtils.SetView keys = SetUtils.intersection(this.getKeys(), other.getKeys());
        for (String key : keys) {
            try {
                Lattice<?> v = this.get(key);
                Lattice<?> o = other.get(key);
                if (v == null || o == null) continue;
                function.put(key, v.glb(o));
            }
            catch (SemanticException e) {
                throw new SemanticException("Exception while operating on '" + key + "'", e);
            }
        }
        return new FixpointInfo(function);
    }

    @Override
    public FixpointInfo wideningAux(FixpointInfo other) throws SemanticException {
        Map<String, Lattice<?>> function = this.mkNewFunction(null, false);
        SetUtils.SetView keys = SetUtils.union(this.getKeys(), other.getKeys());
        for (String key : keys) {
            try {
                Lattice<?> v = this.get(key);
                Lattice<?> o = other.get(key);
                if (v != null && o != null) {
                    function.put(key, v.widening(o));
                    continue;
                }
                if (v != null) {
                    function.put(key, v);
                    continue;
                }
                function.put(key, o);
            }
            catch (SemanticException e) {
                throw new SemanticException("Exception while operating on '" + key + "'", e);
            }
        }
        return new FixpointInfo(function);
    }

    @Override
    public FixpointInfo narrowingAux(FixpointInfo other) throws SemanticException {
        Map<String, Lattice<?>> function = this.mkNewFunction(null, false);
        SetUtils.SetView keys = SetUtils.intersection(this.getKeys(), other.getKeys());
        for (String key : keys) {
            try {
                Lattice<?> v = this.get(key);
                Lattice<?> o = other.get(key);
                if (v == null || o == null) continue;
                function.put(key, v.narrowing(o));
            }
            catch (SemanticException e) {
                throw new SemanticException("Exception while operating on '" + key + "'", e);
            }
        }
        return new FixpointInfo(function);
    }

    @Override
    public boolean lessOrEqualAux(FixpointInfo other) throws SemanticException {
        if (this.function != null) {
            for (String key : this.function.keySet()) {
                Lattice<?> v = this.get(key);
                Lattice<?> o = other.get(key);
                if (v == null || o != null && v.lessOrEqual(o)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public FixpointInfo top() {
        return new FixpointInfo();
    }

    @Override
    public boolean isTop() {
        return this.function == null;
    }

    @Override
    public FixpointInfo bottom() {
        return BOTTOM;
    }

    @Override
    public boolean isBottom() {
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.function == null ? 0 : this.function.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FixpointInfo other = (FixpointInfo)obj;
        return !(this.function == null ? other.function != null : !this.function.equals(other.function));
    }

    @Override
    public String toString() {
        if (this.isTop()) {
            return "#TOP#";
        }
        if (this.isBottom()) {
            return "_|_";
        }
        return this.function == null ? "{}" : this.function.toString();
    }

    @Override
    public Iterator<Map.Entry<String, Lattice<?>>> iterator() {
        if (this.function == null) {
            return Collections.emptyIterator();
        }
        return this.function.entrySet().iterator();
    }

    public Set<String> getKeys() {
        if (this.function == null) {
            return Collections.emptySet();
        }
        return this.function.keySet();
    }

    public Collection<Lattice<?>> getValues() {
        if (this.function == null) {
            return Collections.emptySet();
        }
        return this.function.values();
    }

    public Map<String, Lattice<?>> getMap() {
        return this.function;
    }

    @Override
    public StructuredRepresentation representation() {
        if (this.function == null) {
            return new StringRepresentation("empty");
        }
        return new MapRepresentation(this.function, StringRepresentation::new, StructuredObject::representation);
    }
}

