/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis;

import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.SemanticException;

public interface BaseLattice<L extends BaseLattice<L>>
extends Lattice<L> {
    @Override
    default public boolean lessOrEqual(L other) throws SemanticException {
        if (other == null) {
            return false;
        }
        if (this == other || this.isBottom() || other.isTop() || this.equals(other)) {
            return true;
        }
        if (this.isTop() || other.isBottom()) {
            return false;
        }
        return this.lessOrEqualAux(other);
    }

    @Override
    default public L lub(L other) throws SemanticException {
        if (other == null || other.isBottom() || this.isTop() || this == other || this.equals(other)) {
            return (L)this;
        }
        if (this.isBottom() || other.isTop()) {
            return other;
        }
        return this.lubAux(other);
    }

    @Override
    default public L glb(L other) throws SemanticException {
        if (other == null || this.isBottom() || other.isTop() || this == other || this.equals(other)) {
            return (L)this;
        }
        if (other.isBottom() || this.isTop()) {
            return other;
        }
        return this.glbAux(other);
    }

    @Override
    default public L widening(L other) throws SemanticException {
        if (other == null || other.isBottom() || this.isTop() || this == other || this.equals(other)) {
            return (L)this;
        }
        if (this.isBottom() || other.isTop()) {
            return other;
        }
        return this.wideningAux(other);
    }

    @Override
    default public L narrowing(L other) throws SemanticException {
        if (other == null || this.isBottom() || this == other || this.equals(other)) {
            return (L)this;
        }
        if (this.isTop() || other.isBottom()) {
            return other;
        }
        return this.narrowingAux(other);
    }

    public L lubAux(L var1) throws SemanticException;

    default public L glbAux(L other) throws SemanticException {
        return (L)((BaseLattice)this.bottom());
    }

    default public L wideningAux(L other) throws SemanticException {
        return this.lubAux(other);
    }

    default public L narrowingAux(L other) throws SemanticException {
        return this.glbAux(other);
    }

    public boolean lessOrEqualAux(L var1) throws SemanticException;

    public boolean equals(Object var1);

    public int hashCode();

    public String toString();
}

