/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.AnalyzedCFG;
import it.unive.lisa.analysis.BackwardAnalyzedCFG;
import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.ScopeToken;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.symbols.SymbolAliasing;
import it.unive.lisa.conf.FixpointConfiguration;
import it.unive.lisa.interprocedural.CFGResults;
import it.unive.lisa.interprocedural.FixpointResults;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.interprocedural.InterproceduralAnalysisException;
import it.unive.lisa.interprocedural.OpenCallPolicy;
import it.unive.lisa.interprocedural.ScopeId;
import it.unive.lisa.interprocedural.callgraph.CallGraph;
import it.unive.lisa.interprocedural.callgraph.CallResolutionException;
import it.unive.lisa.logging.TimerLogger;
import it.unive.lisa.program.Application;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.fixpoints.BackwardAscendingFixpoint;
import it.unive.lisa.program.cfg.fixpoints.CFGFixpoint;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.program.cfg.statement.call.CFGCall;
import it.unive.lisa.program.cfg.statement.call.Call;
import it.unive.lisa.program.cfg.statement.call.OpenCall;
import it.unive.lisa.program.cfg.statement.call.UnresolvedCall;
import it.unive.lisa.type.Type;
import it.unive.lisa.util.collections.workset.FIFOWorkingSet;
import it.unive.lisa.util.collections.workset.WorkingSet;
import it.unive.lisa.util.datastructures.graph.algorithms.BackwardFixpoint;
import it.unive.lisa.util.datastructures.graph.algorithms.FixpointException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BackwardOptimizedAnalyzedCFG<A extends AbstractState<A>>
extends BackwardAnalyzedCFG<A> {
    private static final Logger LOG = LogManager.getLogger(BackwardOptimizedAnalyzedCFG.class);
    private final InterproceduralAnalysis<A> interprocedural;
    private StatementStore<A> expanded;

    public BackwardOptimizedAnalyzedCFG(CFG cfg, ScopeId id, AnalysisState<A> singleton, InterproceduralAnalysis<A> interprocedural) {
        super(cfg, id, singleton);
        this.interprocedural = interprocedural;
    }

    public BackwardOptimizedAnalyzedCFG(CFG cfg, ScopeId id, AnalysisState<A> singleton, Map<Statement, AnalysisState<A>> exitStates, Map<Statement, AnalysisState<A>> results, InterproceduralAnalysis<A> interprocedural) {
        super(cfg, id, singleton, exitStates, results);
        this.interprocedural = interprocedural;
    }

    public BackwardOptimizedAnalyzedCFG(CFG cfg, ScopeId id, StatementStore<A> exitStates, StatementStore<A> results, InterproceduralAnalysis<A> interprocedural) {
        super(cfg, id, exitStates, results);
        this.interprocedural = interprocedural;
    }

    private BackwardOptimizedAnalyzedCFG(CFG cfg, ScopeId id, StatementStore<A> exitStates, StatementStore<A> results, StatementStore<A> expanded, InterproceduralAnalysis<A> interprocedural) {
        super(cfg, id, exitStates, results);
        this.interprocedural = interprocedural;
        this.expanded = expanded;
    }

    public AnalysisState<A> getUnwindedAnalysisStateBefore(Statement st, FixpointConfiguration conf) {
        if (this.results.getKeys().contains(st)) {
            return (AnalysisState)this.results.getState(st);
        }
        if (this.expanded != null) {
            return (AnalysisState)this.expanded.getState(st);
        }
        this.unwind(conf);
        return (AnalysisState)this.expanded.getState(st);
    }

    public void unwind(FixpointConfiguration conf) {
        Lattice bottom = ((AnalysisState)this.results.lattice).bottom();
        StatementStore bot = new StatementStore(bottom);
        HashMap starting = new HashMap();
        for (Map.Entry entry : this.exitStates) {
            starting.put((Statement)entry.getKey(), CFGFixpoint.CompoundState.of((AnalysisState)entry.getValue(), bot));
        }
        HashMap<Statement, CFGFixpoint.CompoundState> existing = new HashMap<Statement, CFGFixpoint.CompoundState>();
        CFGFixpoint.CompoundState fallback = CFGFixpoint.CompoundState.of(bottom, bot);
        for (Map.Entry entry : this.results) {
            Statement stmt = (Statement)entry.getKey();
            AnalysisState approx = (AnalysisState)entry.getValue();
            CFGFixpoint.CompoundState def = existing.getOrDefault(stmt, fallback);
            if (!(stmt instanceof Expression) || ((Expression)stmt).getRootStatement() == stmt) {
                existing.put(stmt, CFGFixpoint.CompoundState.of(approx, def.intermediateStates));
                continue;
            }
            Expression e = (Expression)stmt;
            CFGFixpoint.CompoundState val = existing.computeIfAbsent(e.getRootStatement(), arg_0 -> BackwardOptimizedAnalyzedCFG.lambda$unwind$0((AnalysisState)bottom, bot, arg_0));
            val.intermediateStates.put(e, approx);
        }
        BackwardAscendingFixpoint asc = new BackwardAscendingFixpoint(this, new PrecomputedAnalysis(), conf);
        BackwardFixpoint fix = new BackwardFixpoint(this, true);
        TimerLogger.execAction(LOG, "Unwinding optimizied results of " + this, () -> this.lambda$unwind$1(fix, starting, asc, existing, (AnalysisState)bottom));
    }

    public boolean hasPreStateOf(Statement st) {
        return this.results.getKeys().contains(st);
    }

    public void storePreStateOf(Statement st, AnalysisState<A> prestate) {
        this.results.put(st, prestate);
    }

    @Override
    public BackwardOptimizedAnalyzedCFG<A> lubAux(BackwardAnalyzedCFG<A> other) throws SemanticException {
        if (!(this.getDescriptor().equals(other.getDescriptor()) && this.sameIDs(other) && other instanceof BackwardOptimizedAnalyzedCFG)) {
            throw new SemanticException("Cannot lub two graphs with different descriptor or different IDs");
        }
        BackwardOptimizedAnalyzedCFG o = (BackwardOptimizedAnalyzedCFG)other;
        return new BackwardOptimizedAnalyzedCFG((CFG)this, this.id, this.exitStates.lub(other.exitStates), this.results.lub(other.results), this.expanded == null ? o.expanded : this.expanded.lub(o.expanded), this.interprocedural);
    }

    @Override
    public BackwardOptimizedAnalyzedCFG<A> glbAux(BackwardAnalyzedCFG<A> other) throws SemanticException {
        if (!(this.getDescriptor().equals(other.getDescriptor()) && this.sameIDs(other) && other instanceof BackwardOptimizedAnalyzedCFG)) {
            throw new SemanticException("Cannot glb two graphs with different descriptor or different IDs");
        }
        BackwardOptimizedAnalyzedCFG o = (BackwardOptimizedAnalyzedCFG)other;
        return new BackwardOptimizedAnalyzedCFG((CFG)this, this.id, this.exitStates.glb(other.exitStates), this.results.glb(other.results), this.expanded == null ? o.expanded : this.expanded.glb(o.expanded), this.interprocedural);
    }

    @Override
    public BackwardOptimizedAnalyzedCFG<A> wideningAux(BackwardAnalyzedCFG<A> other) throws SemanticException {
        if (!(this.getDescriptor().equals(other.getDescriptor()) && this.sameIDs(other) && other instanceof BackwardOptimizedAnalyzedCFG)) {
            throw new SemanticException("Cannot widen two graphs with different descriptor or different IDs");
        }
        BackwardOptimizedAnalyzedCFG o = (BackwardOptimizedAnalyzedCFG)other;
        return new BackwardOptimizedAnalyzedCFG((CFG)this, this.id, this.exitStates.widening(other.exitStates), this.results.widening(other.results), this.expanded == null ? o.expanded : this.expanded.widening(o.expanded), this.interprocedural);
    }

    @Override
    public BackwardOptimizedAnalyzedCFG<A> narrowingAux(BackwardAnalyzedCFG<A> other) throws SemanticException {
        if (!(this.getDescriptor().equals(other.getDescriptor()) && this.sameIDs(other) && other instanceof BackwardOptimizedAnalyzedCFG)) {
            throw new SemanticException("Cannot perform narrow two graphs with different descriptor or different IDs");
        }
        BackwardOptimizedAnalyzedCFG o = (BackwardOptimizedAnalyzedCFG)other;
        return new BackwardOptimizedAnalyzedCFG((CFG)this, this.id, this.exitStates.narrowing(other.exitStates), this.results.narrowing(other.results), this.expanded == null ? o.expanded : this.expanded.narrowing(o.expanded), this.interprocedural);
    }

    @Override
    public BackwardOptimizedAnalyzedCFG<A> top() {
        return new BackwardOptimizedAnalyzedCFG<A>((CFG)this, this.id.startingId(), this.exitStates.top(), this.results.top(), null, null);
    }

    @Override
    public BackwardOptimizedAnalyzedCFG<A> bottom() {
        return new BackwardOptimizedAnalyzedCFG<A>((CFG)this, this.id.startingId(), this.exitStates.bottom(), this.results.bottom(), null, null);
    }

    private /* synthetic */ void lambda$unwind$1(BackwardFixpoint fix, Map starting, BackwardAscendingFixpoint asc, Map existing, AnalysisState bottom) {
        try {
            Map res = fix.fixpoint(starting, FIFOWorkingSet.mk(), asc, existing);
            this.expanded = new StatementStore(bottom);
            for (Map.Entry e : res.entrySet()) {
                this.expanded.put((Statement)e.getKey(), ((CFGFixpoint.CompoundState)e.getValue()).postState);
                for (Map.Entry entry : ((CFGFixpoint.CompoundState)e.getValue()).intermediateStates) {
                    this.expanded.put((Statement)entry.getKey(), (AnalysisState)entry.getValue());
                }
            }
        }
        catch (FixpointException e) {
            LOG.error("Unable to unwind optimized results of " + this, (Throwable)e);
        }
    }

    private static /* synthetic */ CFGFixpoint.CompoundState lambda$unwind$0(AnalysisState bottom, StatementStore bot, Statement ex) {
        return CFGFixpoint.CompoundState.of(bottom, bot.bottom());
    }

    private class PrecomputedAnalysis
    implements InterproceduralAnalysis<A> {
        private PrecomputedAnalysis() {
        }

        @Override
        public void init(Application app, CallGraph callgraph, OpenCallPolicy policy) throws InterproceduralAnalysisException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void fixpoint(AnalysisState<A> exitState, Class<? extends WorkingSet<Statement>> fixpointWorkingSet, FixpointConfiguration conf) throws FixpointException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<AnalyzedCFG<A>> getAnalysisResultsOf(CFG cfg) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AnalysisState<A> getAbstractResultOf(CFGCall call, AnalysisState<A> exitState, ExpressionSet[] parameters, StatementStore<A> expressions) throws SemanticException {
            Call source;
            Call call2 = source = call.getSource() == null ? call : call.getSource();
            if (BackwardOptimizedAnalyzedCFG.this.results.getKeys().contains(source)) {
                return (AnalysisState)BackwardOptimizedAnalyzedCFG.this.results.getState(source);
            }
            FixpointResults precomputed = BackwardOptimizedAnalyzedCFG.this.interprocedural.getFixpointResults();
            ScopeToken scope = new ScopeToken(call);
            ScopeId id = BackwardOptimizedAnalyzedCFG.this.getId().push(call);
            AnalysisState state = exitState.bottom();
            for (CFG target : call.getTargetedCFGs()) {
                AnalysisState res = ((AnalyzedCFG)((CFGResults)precomputed.getState(target)).getState(id)).getExitState();
                state = state.lub(this.unscope(call, scope, res));
            }
            return state;
        }

        @Override
        public AnalysisState<A> getAbstractResultOf(OpenCall call, AnalysisState<A> exitState, ExpressionSet[] parameters, StatementStore<A> expressions) throws SemanticException {
            return BackwardOptimizedAnalyzedCFG.this.interprocedural.getAbstractResultOf(call, exitState, parameters, expressions);
        }

        @Override
        public Call resolve(UnresolvedCall call, Set<Type>[] types, SymbolAliasing aliasing) throws CallResolutionException {
            return BackwardOptimizedAnalyzedCFG.this.interprocedural.resolve(call, types, aliasing);
        }

        @Override
        public FixpointResults<A> getFixpointResults() {
            return BackwardOptimizedAnalyzedCFG.this.interprocedural.getFixpointResults();
        }

        @Override
        public boolean needsCallGraph() {
            return false;
        }
    }
}

