/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.interprocedural.ScopeId;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.program.cfg.statement.call.Call;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class BackwardAnalyzedCFG<A extends AbstractState<A>>
extends CFG
implements BaseLattice<BackwardAnalyzedCFG<A>> {
    protected static final String CANNOT_LUB_ERROR = "Cannot lub two graphs with different descriptor or different IDs";
    protected static final String CANNOT_GLB_ERROR = "Cannot glb two graphs with different descriptor or different IDs";
    protected static final String CANNOT_WIDEN_ERROR = "Cannot widen two graphs with different descriptor or different IDs";
    protected static final String CANNOT_NARROW_ERROR = "Cannot perform narrow two graphs with different descriptor or different IDs";
    protected static final String CANNOT_COMPARE_ERROR = "Cannot compare two graphs with different descriptor or different IDs";
    protected final StatementStore<A> results;
    protected final StatementStore<A> exitStates;
    protected final ScopeId id;

    public BackwardAnalyzedCFG(CFG cfg, ScopeId id, AnalysisState<A> singleton) {
        this(cfg, id, singleton, Collections.emptyMap(), Collections.emptyMap());
    }

    public BackwardAnalyzedCFG(CFG cfg, ScopeId id, AnalysisState<A> singleton, Map<Statement, AnalysisState<A>> exitStates, Map<Statement, AnalysisState<A>> results) {
        super(cfg);
        this.results = new StatementStore<A>(singleton);
        results.forEach(this.results::put);
        this.exitStates = new StatementStore<A>(singleton);
        exitStates.forEach(this.exitStates::put);
        this.id = id;
    }

    public BackwardAnalyzedCFG(CFG cfg, ScopeId id, StatementStore<A> exitStates, StatementStore<A> results) {
        super(cfg);
        this.results = results;
        this.exitStates = exitStates;
        this.id = id;
    }

    public ScopeId getId() {
        return this.id;
    }

    public AnalysisState<A> getAnalysisStateBefore(Statement st) {
        if (st instanceof Call) {
            Call original = (Call)st;
            while (original.getSource() != null) {
                original = original.getSource();
            }
            st = original;
        }
        return (AnalysisState)this.results.getState(st);
    }

    public AnalysisState<A> getAnalysisStateAfter(Statement st) throws SemanticException {
        if (st instanceof Call) {
            Call original = (Call)st;
            while (original.getSource() != null) {
                original = original.getSource();
            }
            st = original;
        }
        if (!(st instanceof Expression) || ((Expression)st).getParentStatement() == null) {
            if (this.getAllExitpoints().contains(st)) {
                return (AnalysisState)this.exitStates.getState(st);
            }
            return this.lub(this.followersOf(st), true);
        }
        Statement succ = st.getEvaluationSuccessor();
        if (succ != null) {
            return (AnalysisState)this.results.getState(succ);
        }
        Statement target = ((Expression)st).getRootStatement();
        if (this.getAllExitpoints().contains(target)) {
            return (AnalysisState)this.exitStates.getState(target);
        }
        return ((AnalysisState)this.exitStates.lattice).bottom();
    }

    public AnalysisState<A> getEntryState() throws SemanticException {
        return this.lub(this.getEntrypoints(), true);
    }

    public AnalysisState<A> getExitState() throws SemanticException {
        return this.lub(this.getNormalExitpoints(), false);
    }

    private AnalysisState<A> lub(Collection<Statement> statements, boolean entry) throws SemanticException {
        AnalysisState<A> result = ((AnalysisState)this.exitStates.lattice).bottom();
        for (Statement st : statements) {
            result = result.lub(entry ? this.getAnalysisStateBefore(st) : this.getAnalysisStateAfter(st));
        }
        return result;
    }

    @Override
    public BackwardAnalyzedCFG<A> lubAux(BackwardAnalyzedCFG<A> other) throws SemanticException {
        if (!this.getDescriptor().equals(other.getDescriptor()) || !this.sameIDs(other)) {
            throw new SemanticException(CANNOT_LUB_ERROR);
        }
        return new BackwardAnalyzedCFG<A>(this, this.id, this.exitStates.lub(other.exitStates), this.results.lub(other.results));
    }

    @Override
    public BackwardAnalyzedCFG<A> glbAux(BackwardAnalyzedCFG<A> other) throws SemanticException {
        if (!this.getDescriptor().equals(other.getDescriptor()) || !this.sameIDs(other)) {
            throw new SemanticException(CANNOT_GLB_ERROR);
        }
        return new BackwardAnalyzedCFG<A>(this, this.id, this.exitStates.glb(other.exitStates), this.results.glb(other.results));
    }

    @Override
    public BackwardAnalyzedCFG<A> wideningAux(BackwardAnalyzedCFG<A> other) throws SemanticException {
        if (!this.getDescriptor().equals(other.getDescriptor()) || !this.sameIDs(other)) {
            throw new SemanticException(CANNOT_WIDEN_ERROR);
        }
        return new BackwardAnalyzedCFG<A>(this, this.id, this.exitStates.widening(other.exitStates), this.results.widening(other.results));
    }

    @Override
    public BackwardAnalyzedCFG<A> narrowingAux(BackwardAnalyzedCFG<A> other) throws SemanticException {
        if (!this.getDescriptor().equals(other.getDescriptor()) || !this.sameIDs(other)) {
            throw new SemanticException(CANNOT_NARROW_ERROR);
        }
        return new BackwardAnalyzedCFG<A>(this, this.id, this.exitStates.narrowing(other.exitStates), this.results.narrowing(other.results));
    }

    @Override
    public boolean lessOrEqualAux(BackwardAnalyzedCFG<A> other) throws SemanticException {
        if (!this.getDescriptor().equals(other.getDescriptor()) || !this.sameIDs(other)) {
            throw new SemanticException(CANNOT_COMPARE_ERROR);
        }
        return this.exitStates.lessOrEqual(other.exitStates) && this.results.lessOrEqual(other.results);
    }

    protected boolean sameIDs(BackwardAnalyzedCFG<A> other) {
        if (this.id == null) {
            return other.id == null;
        }
        if (other.id == null) {
            return false;
        }
        return this.id.equals(other.id);
    }

    @Override
    public BackwardAnalyzedCFG<A> top() {
        return new BackwardAnalyzedCFG<A>(this, this.id.startingId(), this.exitStates.top(), this.results.top());
    }

    @Override
    public boolean isTop() {
        return this.exitStates.isTop() && this.results.isTop();
    }

    @Override
    public BackwardAnalyzedCFG<A> bottom() {
        return new BackwardAnalyzedCFG<A>(this, this.id.startingId(), this.exitStates.bottom(), this.results.bottom());
    }

    @Override
    public boolean isBottom() {
        return this.exitStates.isBottom() && this.results.isBottom();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.exitStates == null ? 0 : this.exitStates.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.results == null ? 0 : this.results.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BackwardAnalyzedCFG other = (BackwardAnalyzedCFG)obj;
        if (this.exitStates == null ? other.exitStates != null : !this.exitStates.equals(other.exitStates)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.results == null ? other.results != null : !this.results.equals(other.results));
    }

    @Override
    public StructuredRepresentation representation() {
        throw new UnsupportedOperationException();
    }
}

