/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.StatementStore;
import it.unive.lisa.interprocedural.ScopeId;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.program.cfg.statement.call.Call;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class AnalyzedCFG<A extends AbstractState<A>>
extends CFG
implements BaseLattice<AnalyzedCFG<A>> {
    protected static final String CANNOT_LUB_ERROR = "Cannot lub two graphs with different descriptor or different IDs";
    protected static final String CANNOT_GLB_ERROR = "Cannot glb two graphs with different descriptor or different IDs";
    protected static final String CANNOT_WIDEN_ERROR = "Cannot widen two graphs with different descriptor or different IDs";
    protected static final String CANNOT_NARROW_ERROR = "Cannot perform narrow two graphs with different descriptor or different IDs";
    protected static final String CANNOT_COMPARE_ERROR = "Cannot compare two graphs with different descriptor or different IDs";
    protected final StatementStore<A> results;
    protected final StatementStore<A> entryStates;
    protected final ScopeId id;

    public AnalyzedCFG(CFG cfg, ScopeId id, AnalysisState<A> singleton) {
        this(cfg, id, singleton, Collections.emptyMap(), Collections.emptyMap());
    }

    public AnalyzedCFG(CFG cfg, ScopeId id, AnalysisState<A> singleton, Map<Statement, AnalysisState<A>> entryStates, Map<Statement, AnalysisState<A>> results) {
        super(cfg);
        this.results = new StatementStore<A>(singleton);
        results.forEach(this.results::put);
        this.entryStates = new StatementStore<A>(singleton);
        entryStates.forEach(this.entryStates::put);
        this.id = id;
    }

    public AnalyzedCFG(CFG cfg, ScopeId id, StatementStore<A> entryStates, StatementStore<A> results) {
        super(cfg);
        this.results = results;
        this.entryStates = entryStates;
        this.id = id;
    }

    public ScopeId getId() {
        return this.id;
    }

    public AnalysisState<A> getAnalysisStateBefore(Statement st) throws SemanticException {
        if (st instanceof Call) {
            Call original = (Call)st;
            while (original.getSource() != null) {
                original = original.getSource();
            }
            st = original;
        }
        if (!(st instanceof Expression) || ((Expression)st).getParentStatement() == null) {
            if (this.getEntrypoints().contains(st)) {
                return (AnalysisState)this.entryStates.getState(st);
            }
            return this.lub(this.predecessorsOf(st), false);
        }
        Statement pred = st.getEvaluationPredecessor();
        if (pred != null) {
            return (AnalysisState)this.results.getState(pred);
        }
        Statement root = ((Expression)st).getRootStatement();
        if (this.getEntrypoints().contains(root)) {
            return (AnalysisState)this.entryStates.getState(root);
        }
        return ((AnalysisState)this.entryStates.lattice).bottom();
    }

    public AnalysisState<A> getAnalysisStateAfter(Statement st) {
        if (st instanceof Call) {
            Call original = (Call)st;
            while (original.getSource() != null) {
                original = original.getSource();
            }
            st = original;
        }
        return (AnalysisState)this.results.getState(st);
    }

    public AnalysisState<A> getEntryState() throws SemanticException {
        return this.lub(this.getEntrypoints(), true);
    }

    public AnalysisState<A> getExitState() throws SemanticException {
        return this.lub(this.getNormalExitpoints(), false);
    }

    private AnalysisState<A> lub(Collection<Statement> statements, boolean entry) throws SemanticException {
        AnalysisState<A> result = ((AnalysisState)this.entryStates.lattice).bottom();
        for (Statement st : statements) {
            result = result.lub(entry ? this.getAnalysisStateBefore(st) : this.getAnalysisStateAfter(st));
        }
        return result;
    }

    @Override
    public AnalyzedCFG<A> lubAux(AnalyzedCFG<A> other) throws SemanticException {
        if (!this.getDescriptor().equals(other.getDescriptor()) || !this.sameIDs(other)) {
            throw new SemanticException(CANNOT_LUB_ERROR);
        }
        return new AnalyzedCFG<A>(this, this.id, this.entryStates.lub(other.entryStates), this.results.lub(other.results));
    }

    @Override
    public AnalyzedCFG<A> glbAux(AnalyzedCFG<A> other) throws SemanticException {
        if (!this.getDescriptor().equals(other.getDescriptor()) || !this.sameIDs(other)) {
            throw new SemanticException(CANNOT_GLB_ERROR);
        }
        return new AnalyzedCFG<A>(this, this.id, this.entryStates.glb(other.entryStates), this.results.glb(other.results));
    }

    @Override
    public AnalyzedCFG<A> wideningAux(AnalyzedCFG<A> other) throws SemanticException {
        if (!this.getDescriptor().equals(other.getDescriptor()) || !this.sameIDs(other)) {
            throw new SemanticException(CANNOT_WIDEN_ERROR);
        }
        return new AnalyzedCFG<A>(this, this.id, this.entryStates.widening(other.entryStates), this.results.widening(other.results));
    }

    @Override
    public AnalyzedCFG<A> narrowingAux(AnalyzedCFG<A> other) throws SemanticException {
        if (!this.getDescriptor().equals(other.getDescriptor()) || !this.sameIDs(other)) {
            throw new SemanticException(CANNOT_NARROW_ERROR);
        }
        return new AnalyzedCFG<A>(this, this.id, this.entryStates.narrowing(other.entryStates), this.results.narrowing(other.results));
    }

    @Override
    public boolean lessOrEqualAux(AnalyzedCFG<A> other) throws SemanticException {
        if (!this.getDescriptor().equals(other.getDescriptor()) || !this.sameIDs(other)) {
            throw new SemanticException(CANNOT_COMPARE_ERROR);
        }
        return this.entryStates.lessOrEqual(other.entryStates) && this.results.lessOrEqual(other.results);
    }

    protected boolean sameIDs(AnalyzedCFG<A> other) {
        if (this.id == null) {
            return other.id == null;
        }
        if (other.id == null) {
            return false;
        }
        return this.id.equals(other.id);
    }

    @Override
    public AnalyzedCFG<A> top() {
        return new AnalyzedCFG<A>(this, this.id.startingId(), this.entryStates.top(), this.results.top());
    }

    @Override
    public boolean isTop() {
        return this.entryStates.isTop() && this.results.isTop();
    }

    @Override
    public AnalyzedCFG<A> bottom() {
        return new AnalyzedCFG<A>(this, this.id.startingId(), this.entryStates.bottom(), this.results.bottom());
    }

    @Override
    public boolean isBottom() {
        return this.entryStates.isBottom() && this.results.isBottom();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entryStates == null ? 0 : this.entryStates.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.results == null ? 0 : this.results.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnalyzedCFG other = (AnalyzedCFG)obj;
        if (this.entryStates == null ? other.entryStates != null : !this.entryStates.equals(other.entryStates)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.results == null ? other.results != null : !this.results.equals(other.results));
    }

    @Override
    public StructuredRepresentation representation() {
        throw new UnsupportedOperationException();
    }
}

