/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa.analysis;

import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.BaseLattice;
import it.unive.lisa.analysis.FixpointInfo;
import it.unive.lisa.analysis.Lattice;
import it.unive.lisa.analysis.ScopeToken;
import it.unive.lisa.analysis.ScopedObject;
import it.unive.lisa.analysis.SemanticException;
import it.unive.lisa.analysis.SemanticOracle;
import it.unive.lisa.analysis.lattices.ExpressionSet;
import it.unive.lisa.analysis.lattices.Satisfiability;
import it.unive.lisa.program.cfg.ProgramPoint;
import it.unive.lisa.symbolic.SymbolicExpression;
import it.unive.lisa.symbolic.value.Identifier;
import it.unive.lisa.util.representation.ObjectRepresentation;
import it.unive.lisa.util.representation.StructuredObject;
import it.unive.lisa.util.representation.StructuredRepresentation;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Predicate;

public class AnalysisState<A extends AbstractState<A>>
implements BaseLattice<AnalysisState<A>>,
StructuredObject,
ScopedObject<AnalysisState<A>> {
    private final A state;
    private final FixpointInfo info;
    private final ExpressionSet computedExpressions;

    public AnalysisState(A state, SymbolicExpression computedExpression) {
        this(state, new ExpressionSet(computedExpression), null);
    }

    public AnalysisState(A state, ExpressionSet computedExpressions) {
        this(state, computedExpressions, null);
    }

    public AnalysisState(A state, SymbolicExpression computedExpression, FixpointInfo info) {
        this(state, new ExpressionSet(computedExpression), info);
    }

    public AnalysisState(A state, ExpressionSet computedExpressions, FixpointInfo info) {
        this.state = state;
        this.computedExpressions = computedExpressions;
        this.info = info;
    }

    public A getState() {
        return this.state;
    }

    public FixpointInfo getFixpointInformation() {
        return this.info;
    }

    public Lattice<?> getInfo(String key) {
        return this.info == null ? null : this.info.get(key);
    }

    public <T> T getInfo(String key, Class<T> type) {
        return this.info == null ? null : (T)this.info.get(key, type);
    }

    public AnalysisState<A> storeInfo(String key, Lattice<?> info) {
        FixpointInfo fixinfo = this.info == null ? new FixpointInfo() : this.info;
        fixinfo = fixinfo.put(key, info);
        return new AnalysisState<A>(this.state, this.computedExpressions, fixinfo);
    }

    public AnalysisState<A> weakStoreInfo(String key, Lattice<?> info) throws SemanticException {
        FixpointInfo fixinfo = this.info == null ? new FixpointInfo() : this.info;
        fixinfo = fixinfo.putWeak(key, info);
        return new AnalysisState<A>(this.state, this.computedExpressions, fixinfo);
    }

    public ExpressionSet getComputedExpressions() {
        return this.computedExpressions;
    }

    public AnalysisState<A> assign(Identifier id, SymbolicExpression value, ProgramPoint pp) throws SemanticException {
        AbstractState s = (AbstractState)this.state.assign((Identifier)id, (SymbolicExpression)value, pp, (SemanticOracle)this.state);
        return new AnalysisState<AbstractState>(s, new ExpressionSet(id), this.info);
    }

    public AnalysisState<A> assign(SymbolicExpression id, SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        if (id instanceof Identifier) {
            return this.assign((Identifier)id, expression, pp);
        }
        AbstractState s = (AbstractState)this.state.bottom();
        AnalysisState<A> sem = this.smallStepSemantics(id, pp);
        ExpressionSet rewritten = sem.state.rewrite(id, pp, (SemanticOracle)this.state);
        for (SymbolicExpression i : rewritten) {
            if (!(i instanceof Identifier)) {
                throw new SemanticException("Rewriting '" + id + "' did not produce an identifier: " + i);
            }
            s = s.lub((AbstractState)sem.state.assign((Identifier)((Identifier)i), (SymbolicExpression)expression, pp, (SemanticOracle)this.state));
        }
        return new AnalysisState<AbstractState>(s, rewritten, this.info);
    }

    public AnalysisState<A> smallStepSemantics(SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        AbstractState s = (AbstractState)this.state.smallStepSemantics((SymbolicExpression)expression, pp, (SemanticOracle)this.state);
        return new AnalysisState<AbstractState>(s, new ExpressionSet(expression), this.info);
    }

    public AnalysisState<A> assume(SymbolicExpression expression, ProgramPoint src, ProgramPoint dest) throws SemanticException {
        AbstractState assume = (AbstractState)this.state.assume((SymbolicExpression)expression, src, dest, (SemanticOracle)this.state);
        if (assume.isBottom()) {
            return this.bottom();
        }
        return new AnalysisState<AbstractState>(assume, this.computedExpressions, this.info);
    }

    public Satisfiability satisfies(SymbolicExpression expression, ProgramPoint pp) throws SemanticException {
        return this.state.satisfies((SymbolicExpression)expression, pp, (SemanticOracle)this.state);
    }

    @Override
    public AnalysisState<A> pushScope(ScopeToken scope) throws SemanticException {
        return new AnalysisState<AbstractState>((AbstractState)this.state.pushScope(scope), AnalysisState.onAllExpressions(this.computedExpressions, scope, true), this.info);
    }

    private static ExpressionSet onAllExpressions(ExpressionSet computedExpressions, ScopeToken scope, boolean push) throws SemanticException {
        HashSet<SymbolicExpression> result = new HashSet<SymbolicExpression>();
        for (SymbolicExpression exp : computedExpressions) {
            result.add(push ? exp.pushScope(scope) : exp.popScope(scope));
        }
        return new ExpressionSet(result);
    }

    @Override
    public AnalysisState<A> popScope(ScopeToken scope) throws SemanticException {
        return new AnalysisState<AbstractState>((AbstractState)this.state.popScope(scope), AnalysisState.onAllExpressions(this.computedExpressions, scope, false), this.info);
    }

    @Override
    public AnalysisState<A> lubAux(AnalysisState<A> other) throws SemanticException {
        return new AnalysisState<AbstractState>((AbstractState)this.state.lub(other.state), this.computedExpressions.lub(other.computedExpressions), this.info == null ? other.info : this.info.lub(other.info));
    }

    @Override
    public AnalysisState<A> glbAux(AnalysisState<A> other) throws SemanticException {
        return new AnalysisState<AbstractState>((AbstractState)this.state.glb(other.state), this.computedExpressions.glb(other.computedExpressions), this.info == null ? null : this.info.glb(other.info));
    }

    @Override
    public AnalysisState<A> wideningAux(AnalysisState<A> other) throws SemanticException {
        return new AnalysisState<AbstractState>((AbstractState)this.state.widening(other.state), this.computedExpressions.lub(other.computedExpressions), this.info == null ? other.info : this.info.widening(other.info));
    }

    @Override
    public AnalysisState<A> narrowingAux(AnalysisState<A> other) throws SemanticException {
        return new AnalysisState<AbstractState>((AbstractState)this.state.narrowing(other.state), this.computedExpressions.glb(other.computedExpressions), this.info == null ? null : this.info.narrowing(other.info));
    }

    @Override
    public boolean lessOrEqualAux(AnalysisState<A> other) throws SemanticException {
        return this.state.lessOrEqual(other.state) && this.computedExpressions.lessOrEqual(other.computedExpressions) && (this.info == null || this.info.lessOrEqual(other.info));
    }

    @Override
    public AnalysisState<A> top() {
        return new AnalysisState<AbstractState>((AbstractState)this.state.top(), this.computedExpressions.top(), null);
    }

    @Override
    public AnalysisState<A> bottom() {
        return new AnalysisState<AbstractState>((AbstractState)this.state.bottom(), this.computedExpressions.bottom(), FixpointInfo.BOTTOM);
    }

    @Override
    public boolean isTop() {
        return this.state.isTop() && this.computedExpressions.isTop() && this.info == null;
    }

    @Override
    public boolean isBottom() {
        return this.state.isBottom() && this.computedExpressions.isBottom() && this.info != null && this.info.isBottom();
    }

    public AnalysisState<A> forgetIdentifier(Identifier id) throws SemanticException {
        return new AnalysisState<AbstractState>((AbstractState)this.state.forgetIdentifier(id), this.computedExpressions, this.info);
    }

    public AnalysisState<A> forgetIdentifiersIf(Predicate<Identifier> test) throws SemanticException {
        return new AnalysisState<AbstractState>((AbstractState)this.state.forgetIdentifiersIf(test), this.computedExpressions, this.info);
    }

    public AnalysisState<A> forgetIdentifiers(Iterable<Identifier> ids) throws SemanticException {
        AnalysisState<A> result = this;
        for (Identifier id : ids) {
            result = result.forgetIdentifier(id);
        }
        return result;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.info == null ? 0 : this.info.hashCode());
        result = 31 * result + (this.computedExpressions == null ? 0 : this.computedExpressions.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnalysisState other = (AnalysisState)obj;
        if (this.info == null ? other.info != null : !this.info.equals(other.info)) {
            return false;
        }
        if (this.computedExpressions == null ? other.computedExpressions != null : !this.computedExpressions.equals(other.computedExpressions)) {
            return false;
        }
        return !(this.state == null ? other.state != null : !this.state.equals(other.state));
    }

    @Override
    public StructuredRepresentation representation() {
        if (this.isBottom()) {
            return Lattice.bottomRepresentation();
        }
        if (this.isTop()) {
            return Lattice.topRepresentation();
        }
        StructuredRepresentation stateRepr = this.state.representation();
        StructuredRepresentation exprRepr = this.computedExpressions.representation();
        return new ObjectRepresentation(Map.of("state", stateRepr, "expressions", exprRepr));
    }

    public StructuredRepresentation representationWithInfo() {
        if (this.isBottom()) {
            return Lattice.bottomRepresentation();
        }
        if (this.isTop()) {
            return Lattice.topRepresentation();
        }
        if (this.info == null || this.info.isBottom()) {
            return this.representation();
        }
        StructuredRepresentation stateRepr = this.state.representation();
        StructuredRepresentation exprRepr = this.computedExpressions.representation();
        StructuredRepresentation infoRepr = this.info.representation();
        return new ObjectRepresentation(Map.of("state", stateRepr, "expressions", exprRepr, "info", infoRepr));
    }

    @Override
    public String toString() {
        return this.representation().toString();
    }

    public AnalysisState<A> withTopMemory() {
        return new AnalysisState(this.state.withTopMemory(), this.computedExpressions, this.info);
    }

    public AnalysisState<A> withTopValues() {
        return new AnalysisState(this.state.withTopValues(), this.computedExpressions, this.info);
    }

    public AnalysisState<A> withTopTypes() {
        return new AnalysisState(this.state.withTopTypes(), this.computedExpressions, this.info);
    }
}

