/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa;

import it.unive.lisa.AnalysisExecutionException;
import it.unive.lisa.AnalysisSetupException;
import it.unive.lisa.analysis.AbstractState;
import it.unive.lisa.analysis.AnalysisState;
import it.unive.lisa.analysis.AnalyzedCFG;
import it.unive.lisa.analysis.OptimizedAnalyzedCFG;
import it.unive.lisa.checks.ChecksExecutor;
import it.unive.lisa.checks.semantic.CheckToolWithAnalysisResults;
import it.unive.lisa.checks.semantic.SemanticCheck;
import it.unive.lisa.checks.syntactic.CheckTool;
import it.unive.lisa.checks.warnings.Warning;
import it.unive.lisa.conf.FixpointConfiguration;
import it.unive.lisa.conf.LiSAConfiguration;
import it.unive.lisa.interprocedural.InterproceduralAnalysis;
import it.unive.lisa.interprocedural.InterproceduralAnalysisException;
import it.unive.lisa.interprocedural.callgraph.CallGraph;
import it.unive.lisa.interprocedural.callgraph.CallGraphConstructionException;
import it.unive.lisa.logging.IterationLogger;
import it.unive.lisa.logging.TimerLogger;
import it.unive.lisa.outputs.serializableGraph.SerializableGraph;
import it.unive.lisa.outputs.serializableGraph.SerializableValue;
import it.unive.lisa.program.Application;
import it.unive.lisa.program.Program;
import it.unive.lisa.program.ProgramValidationException;
import it.unive.lisa.program.SyntheticLocation;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.symbolic.value.Skip;
import it.unive.lisa.type.ReferenceType;
import it.unive.lisa.type.Type;
import it.unive.lisa.type.TypeSystem;
import it.unive.lisa.util.datastructures.graph.algorithms.FixpointException;
import it.unive.lisa.util.file.FileManager;
import java.io.IOException;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LiSARunner<A extends AbstractState<A>> {
    private static final Logger LOG = LogManager.getLogger(LiSARunner.class);
    private final LiSAConfiguration conf;
    private final FileManager fileManager;
    private final InterproceduralAnalysis<A> interproc;
    private final CallGraph callGraph;
    private final A state;

    LiSARunner(LiSAConfiguration conf, FileManager fileManager, InterproceduralAnalysis<A> interproc, CallGraph callGraph, A state) {
        this.conf = conf;
        this.fileManager = fileManager;
        this.interproc = interproc;
        this.callGraph = callGraph;
        this.state = state;
    }

    Collection<Warning> run(Application app) {
        this.finalize(app);
        Collection<CFG> allCFGs = app.getAllCFGs();
        FixpointConfiguration fixconf = new FixpointConfiguration(this.conf);
        CheckTool tool = new CheckTool(this.conf, this.fileManager);
        if (this.conf.optimize) {
            allCFGs.forEach(CFG::computeBasicBlocks);
        }
        if (this.conf.serializeInputs) {
            this.dumpInputs(allCFGs);
        }
        if (!this.conf.syntacticChecks.isEmpty()) {
            ChecksExecutor.executeAll(tool, app, this.conf.syntacticChecks);
        } else {
            LOG.warn("Skipping syntactic checks execution since none have been provided");
        }
        if (this.canAnalyze()) {
            Collection<SemanticCheck<A>> semanticChecks;
            this.init(app);
            this.analyze(fixconf);
            if (this.conf.serializeResults || this.conf.analysisGraphs != LiSAConfiguration.GraphType.NONE) {
                this.dumpResults(allCFGs, fixconf);
            }
            if (!(semanticChecks = this.conf.semanticChecks).isEmpty()) {
                tool = this.runSemanticChecks(app, allCFGs, tool, semanticChecks);
            } else {
                LOG.warn("Skipping semantic checks execution since none have been provided");
            }
        }
        this.dumpSupportFiles();
        return tool.getWarnings();
    }

    private void finalize(Application app) {
        for (Program p : app.getPrograms()) {
            TypeSystem types = p.getTypes();
            types.registerType(types.getBooleanType());
            types.registerType(types.getStringType());
            types.registerType(types.getIntegerType());
            for (Type t : types.getTypes()) {
                if (!types.canBeReferenced(t)) continue;
                types.registerType(new ReferenceType(t));
            }
            TimerLogger.execAction(LOG, "Finalizing input program", () -> {
                try {
                    p.getFeatures().getProgramValidationLogic().validateAndFinalize(p);
                }
                catch (ProgramValidationException e) {
                    throw new AnalysisExecutionException("Unable to finalize target program", e);
                }
            });
        }
    }

    private void dumpInputs(Collection<CFG> allCFGs) {
        for (CFG cfg : IterationLogger.iterate(LOG, allCFGs, "Dumping input cfgs", "cfgs")) {
            SerializableGraph graph = cfg.toSerializableGraph();
            String filename = cfg.getDescriptor().getFullSignatureWithParNames() + "_cfg";
            try {
                this.fileManager.mkJsonFile(filename, writer -> graph.dump(writer));
                this.dumpSingleGraph(filename, graph);
            }
            catch (IOException e) {
                LOG.error("Exception while dumping the analysis results on {}", (Object)cfg.getDescriptor().getFullSignature());
                LOG.error((Object)e);
            }
        }
    }

    private void init(Application app) {
        try {
            this.callGraph.init(app);
        }
        catch (CallGraphConstructionException e) {
            LOG.fatal("Exception while building the call graph for the input program", (Throwable)e);
            throw new AnalysisSetupException("Exception while building the call graph for the input program", e);
        }
        try {
            this.interproc.init(app, this.callGraph, this.conf.openCallPolicy);
        }
        catch (InterproceduralAnalysisException e) {
            LOG.fatal("Exception while building the interprocedural analysis for the input program", (Throwable)e);
            throw new AnalysisSetupException("Exception while building the interprocedural analysis for the input program", e);
        }
    }

    private boolean canAnalyze() {
        if (this.interproc == null) {
            LOG.warn("Skipping analysis execution since no interprocedural analysis has been provided");
            return false;
        }
        if (this.callGraph == null && this.interproc.needsCallGraph()) {
            throw new AnalysisSetupException("The provided interprocedural analysis needs a call graph to function, but none has been provided");
        }
        if (this.state == null) {
            LOG.warn("Skipping analysis execution since no abstract sate has been provided");
            return false;
        }
        return true;
    }

    private void analyze(FixpointConfiguration fixconf) {
        AbstractState state = (AbstractState)this.state.top();
        TimerLogger.execAction(LOG, "Computing fixpoint over the whole program", () -> {
            try {
                this.interproc.fixpoint(new AnalysisState<AbstractState>(state, new Skip(SyntheticLocation.INSTANCE)), this.conf.fixpointWorkingSet, fixconf);
            }
            catch (FixpointException e) {
                LOG.fatal("Exception during fixpoint computation", (Throwable)e);
                throw new AnalysisExecutionException("Exception during fixpoint computation", e);
            }
        });
    }

    private void dumpResults(Collection<CFG> allCFGs, FixpointConfiguration fixconf) {
        BiFunction<CFG, Statement, SerializableValue> labeler = this.conf.optimize && this.conf.dumpForcesUnwinding ? (cfg, st) -> ((OptimizedAnalyzedCFG)cfg).getUnwindedAnalysisStateAfter((Statement)st, fixconf).representation().toSerializableValue() : (cfg, st) -> ((AnalyzedCFG)cfg).getAnalysisStateAfter((Statement)st).representation().toSerializableValue();
        for (CFG cfg2 : IterationLogger.iterate(LOG, allCFGs, "Dumping analysis results", "cfgs")) {
            for (AnalyzedCFG<A> result : this.interproc.getAnalysisResultsOf(cfg2)) {
                SerializableGraph graph = result.toSerializableGraph(labeler);
                Object filename = cfg2.getDescriptor().getFullSignatureWithParNames();
                if (!result.getId().isStartingId()) {
                    filename = (String)filename + "_" + result.getId().hashCode();
                }
                try {
                    if (this.conf.serializeResults) {
                        this.fileManager.mkJsonFile((String)filename, writer -> graph.dump(writer));
                    }
                    this.dumpSingleGraph((String)filename, graph);
                }
                catch (IOException e) {
                    LOG.error("Exception while dumping the analysis results on {}", (Object)cfg2.getDescriptor().getFullSignature());
                    LOG.error((Object)e);
                }
            }
        }
    }

    private void dumpSingleGraph(String filename, SerializableGraph graph) throws IOException {
        switch (this.conf.analysisGraphs) {
            case DOT: {
                this.fileManager.mkDotFile(filename, writer -> graph.toDot().dump(writer));
                break;
            }
            case GRAPHML: {
                this.fileManager.mkGraphmlFile(filename, writer -> graph.toGraphml(false).dump(writer));
                break;
            }
            case GRAPHML_WITH_SUBNODES: {
                this.fileManager.mkGraphmlFile(filename, writer -> graph.toGraphml(true).dump(writer));
                break;
            }
            case HTML: {
                this.fileManager.mkHtmlFile(filename, writer -> graph.toHtml(false, "results").dump(writer));
                this.fileManager.usedPlainCytoscape();
                break;
            }
            case HTML_WITH_SUBNODES: {
                this.fileManager.mkHtmlFile(filename, writer -> graph.toHtml(true, "results").dump(writer));
                this.fileManager.usedCompoundCytoscape();
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new AnalysisExecutionException("Unknown graph type: " + this.conf.analysisGraphs);
            }
        }
    }

    private CheckTool runSemanticChecks(Application app, Collection<CFG> allCFGs, CheckTool tool, Collection<SemanticCheck<A>> semanticChecks) {
        IdentityHashMap results = new IdentityHashMap(allCFGs.size());
        for (CFG cfg : allCFGs) {
            results.put(cfg, this.interproc.getAnalysisResultsOf(cfg));
        }
        CheckToolWithAnalysisResults tool2 = new CheckToolWithAnalysisResults(tool, results, this.callGraph);
        ChecksExecutor.executeAll(tool2, app, semanticChecks);
        return tool2;
    }

    private void dumpSupportFiles() {
        try {
            this.fileManager.generateSupportFiles();
        }
        catch (IOException e) {
            LOG.error("Exception while generating supporting files for visualization");
            LOG.error((Object)e);
        }
    }
}

