/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa;

import it.unive.lisa.checks.warnings.Warning;
import it.unive.lisa.program.Application;
import it.unive.lisa.program.Program;
import it.unive.lisa.program.cfg.CFG;
import it.unive.lisa.program.cfg.edge.Edge;
import it.unive.lisa.program.cfg.statement.Expression;
import it.unive.lisa.program.cfg.statement.Statement;
import it.unive.lisa.util.datastructures.graph.GraphVisitor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public class LiSARunInfo {
    public static final PeriodFormatter PERIOD_FORMAT = new PeriodFormatterBuilder().appendYears().appendSuffix("Y ").appendMonths().appendSuffix("M ").appendDays().appendSuffix("D ").appendHours().appendSuffix("h ").appendMinutes().appendSuffix("m ").appendSeconds().appendSuffix("s ").appendMillis().appendSuffix("ms").printZeroNever().toFormatter();
    public final String version;
    public final int warnings;
    public final int files;
    public final int units;
    public final int globals;
    public final int members;
    public final int cfgs;
    public final int statements;
    public final int expressions;
    public final int programs;
    public final String start;
    public final String end;
    public final String duration;

    public LiSARunInfo(Collection<Warning> warnings, Collection<String> files, Application app, DateTime start, DateTime end) {
        this.version = "0.1";
        this.warnings = warnings.size();
        this.files = files.size();
        this.programs = app.getPrograms().length;
        int units = 0;
        int globals = 0;
        for (Program p : app.getPrograms()) {
            units += p.getUnits().size();
            globals += p.getGlobalsRecursively().size();
        }
        this.units = units;
        this.globals = globals;
        this.members = app.getAllCodeCodeMembers().size();
        this.cfgs = app.getAllCFGs().size();
        this.start = start.toString();
        this.end = end.toString();
        this.duration = PERIOD_FORMAT.print((ReadablePeriod)new Period((ReadableInstant)start, (ReadableInstant)end)).trim();
        StatementCounter counter = new StatementCounter();
        app.getAllCFGs().forEach(c -> c.accept(counter, null));
        this.statements = counter.statements;
        this.expressions = counter.expressions;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        try {
            for (Field field : LiSARunInfo.class.getFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                result = 31 * result + Objects.hashCode(field.get(this));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IllegalStateException("Cannot access one of this class' public fields", e);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LiSARunInfo other = (LiSARunInfo)obj;
        try {
            for (Field field : LiSARunInfo.class.getFields()) {
                Object ovalue;
                Object value;
                if (Modifier.isStatic(field.getModifiers()) || Objects.equals(value = field.get(this), ovalue = field.get(other))) continue;
                return false;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IllegalStateException("Cannot access one of this class' public fields", e);
        }
        return true;
    }

    public boolean sameCodeAndResults(LiSARunInfo other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.cfgs != other.cfgs) {
            return false;
        }
        if (this.expressions != other.expressions) {
            return false;
        }
        if (this.globals != other.globals) {
            return false;
        }
        if (this.members != other.members) {
            return false;
        }
        if (this.statements != other.statements) {
            return false;
        }
        if (this.units != other.units) {
            return false;
        }
        if (this.warnings != other.warnings) {
            return false;
        }
        if (this.files != other.files) {
            return false;
        }
        return this.programs == other.programs;
    }

    public String toString() {
        return "Version " + this.version + "\nDuration: " + this.duration + " (started: " + this.start + ", ended: " + this.end + ")\nPrograms: " + this.programs + "\nUnits: " + this.units + "\nGlobals: " + this.globals + "\nCode Members: " + this.members + "\nCFGs: " + this.cfgs + "\nStatements: " + this.statements + "\nExpressions: " + this.expressions + "\nGenerated Warnings: " + this.warnings + "\nGenerated Files: " + this.files;
    }

    public Map<String, String> toPropertyBag() {
        TreeMap<String, String> bag = new TreeMap<String, String>();
        try {
            for (Field field : LiSARunInfo.class.getFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                Object value = field.get(this);
                String key = field.getName();
                String val = String.valueOf(value);
                bag.put(key, val);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IllegalStateException("Cannot access one of this class' public fields", e);
        }
        return bag;
    }

    private static class StatementCounter
    implements GraphVisitor<CFG, Statement, Edge, Void> {
        private int statements = 0;
        private int expressions = 0;

        private StatementCounter() {
        }

        @Override
        public boolean visit(Void tool, CFG graph, Statement node) {
            if (node instanceof Expression) {
                if (((Expression)node).getRootStatement() == node) {
                    ++this.statements;
                } else {
                    ++this.expressions;
                }
            } else {
                ++this.statements;
            }
            return true;
        }
    }
}

