/*
 * Decompiled with CFR 0.152.
 */
package it.unive.lisa;

import it.unive.lisa.AnalysisException;
import it.unive.lisa.AnalysisExecutionException;
import it.unive.lisa.LiSAReport;
import it.unive.lisa.LiSARunInfo;
import it.unive.lisa.LiSARunner;
import it.unive.lisa.conf.LiSAConfiguration;
import it.unive.lisa.logging.TimerLogger;
import it.unive.lisa.outputs.json.JsonReport;
import it.unive.lisa.program.Application;
import it.unive.lisa.program.Program;
import it.unive.lisa.util.file.FileManager;
import java.io.IOException;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;

public class LiSA {
    private static final Logger LOG = LogManager.getLogger(LiSA.class);
    public static final String REPORT_NAME = "report.json";
    private final FileManager fileManager;
    private final LiSAConfiguration conf;

    public LiSA(LiSAConfiguration conf) {
        this.conf = conf;
        this.fileManager = new FileManager(conf.workdir);
    }

    public LiSAReport run(Program ... programs) throws AnalysisException {
        Collection warnings;
        LOG.info(this.conf.toString());
        DateTime start = new DateTime();
        LiSARunner runner = new LiSARunner(this.conf, this.fileManager, this.conf.interproceduralAnalysis, this.conf.callGraph, this.conf.abstractState);
        Application app = new Application(programs);
        try {
            warnings = TimerLogger.execSupplier(LOG, "Analysis time", () -> runner.run(app));
        }
        catch (AnalysisExecutionException e) {
            throw new AnalysisException("LiSA has encountered an exception while executing the analysis", e);
        }
        LiSARunInfo stats = new LiSARunInfo(warnings, this.fileManager.createdFiles(), app, start, new DateTime());
        LOG.info("LiSA statistics:\n" + stats);
        LiSAReport report = new LiSAReport(this.conf, stats, warnings, this.fileManager.createdFiles());
        if (this.conf.jsonOutput) {
            LOG.info("Dumping analysis report to 'report.json'");
            try {
                this.fileManager.mkOutputFile(REPORT_NAME, writer -> {
                    JsonReport json = new JsonReport(report);
                    json.dump(writer);
                    LOG.info("Report file dumped to 'report.json'");
                });
            }
            catch (IOException e) {
                LOG.error("Unable to dump report file", (Throwable)e);
            }
        }
        return report;
    }
}

